//   ===============================================================================================
//   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -------------------------------------------------------------------------------------------------
//   Copyright (c) 2021 by Lattice Semiconductor Corporation
// -------------------------------------------------------------------------------------------------
//
// Permission:
//
//   Lattice Semiconductor grants permission to use this code for use in synthesis for any Lattice 
//   programmable logic product.  Other use of this code, including the selling or duplication of 
//   any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL or Verilog source code is intended as a design reference which illustrates how these
//   types of functions can be implemented.  It is the user's responsibility to verify their design
//   for consistency and functionality through the use of formal verification methods.  Lattice 
//   Semiconductor provides no warranty regarding the use or functionality of this code.
//
// -------------------------------------------------------------------------------------------------
//
//                               Lattice Semiconductor Corporation
//                               5555 NE Moore Court
//                               Hillsboro, OR 97214
//                               U.S.A
//                            
//                               TEL: 1-800-Lattice (USA and Canada)
//                                    408-826-6000 (other locations)
//                            
//                               web: http://www.latticesemi.com/
//                               email: techsupport@latticesemi.com
//
// -------------------------------------------------------------------------------------------------
// Filename        : top.v
// Description     : top module 
// Created On      : 2021
// Revision        : Revision: 1.00 
// ------------------------------------------------------------------------------------------------

`timescale 1 ns / 1 ps

module top #(
//-----------------------------------------------------------------------------
// PARAMETERS
//-----------------------------------------------------------------------------
  parameter USER_REG_DATAWIDTH = 32,
  parameter USER_REG_ADDRWIDTH = 9
)
//-----------------------------------------------------------------------------
// PORT DECLARATIONS
//-----------------------------------------------------------------------------
(
  //input 			User_reg_clk,
  input          	rstn,
  //input          	clk,
  output  [7:0]  	leds,
  output  [31:0]	count,
  output		  	lock,
  input		  		direction
  //output  [31:0]	User_reg_rdata,
  //SGMII signals/////////////////////
  //input         	spclk1,
  //output        	srclk1,
  //input         	rst1,
  //input         	sin1,
  //output  [9:0] 	srxd1,
  //// PCIe signals///////////////////
  //input          	rextck,
  //input          	eckin,
  //input          	vxsop,
  //input          	vxeop,
  //output         	vxrdy 
  );


  //wire [(USER_REG_DATAWIDTH-1):0] User_reg_wdata;
  //wire [(USER_REG_ADDRWIDTH-1):0] User_reg_addr;
  //wire User_reg_en;
  //wire User_reg_wr_rdn;
  wire osc_clk;		// connect this to the oscillator output and Pll input
  wire clk_o;       // connect this to the PLL output
  wire clkb;       // connect this to view counter's output change
//* Add my_osc instance here */////////  
  my_osc osc_inst(.hf_out_en_i(1'b1),
        .hf_clk_out_o(osc_clk),
        .lf_clk_out_o( ));	

//* Add my_pll instance here */////////  
  my_pll pll_inst(.clki_i(osc_clk),
			   .rstn_i(rstn),
			   .clkop_o(clk_o),
			   .lock_o(lock));

//-----------------------------------------------------------------------------
// Simple 32 bit Up/Down counter
//----------------------------------------------------------------------------- 

  count32 count32_inst (
  .clk			(clkb),
  .direction	(direction),
  .reset		(rstn),
  .count		(count),
  .lock			(lock)
  );
  
//-----------------------------------------------------------------------------
// LED and CLK DIVIDER for Hardware
//----------------------------------------------------------------------------- 
  led_switch led_switch_inst (
  .clk			(clkb),
  .reset		(rstn),
  .count		(count),
  .leds			(leds)
  );

clk_divider clk_divider_inst(
    .clk	(clk_o),
    .rst	(rstn),
    .clkb	(clkb)
    );
endmodule
  